/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */


class FormManager {
	constructor(dataclass, sel, curpos, formPlaceHolders, attributes = null, gridManager = null, errorManager = null) {
		this.dataclass = dataclass;
		this.sel = sel;
		this.curpos = curpos;

		this.errorManager = errorManager;

		this.attsSettings = SettingManager.getProperty('formManager.attributes', this.dataclass);
		if (this.attsSettings == null)
			this.attsSettings = {};

		this.$formContent = formPlaceHolders.$formContent;
		this.$formTitle = formPlaceHolders.$formTitle;
		this.$formFooter = formPlaceHolders.$formFooter;

		if (attributes == null)
			this.attributes = this.buildAllAttributes();
		else
			this.attributes = attributes;
		this.buildForm(this.attributes);

		this.installToolBar();
		this.grid = gridManager;

		this.queryHandler = null;
	}

	setQueryHandler(queryHandler) {
		this.queryHandler = queryHandler;
	}

	installToolBar() {
		this.$formBar1 = this.$formFooter.find('.formBar1');
		this.$formBar1.find('.formBar1Button').on('click', this.handleNavigateClick.bind(this));

	}

	handleNavigateClick(event) {
		const buttontype = event.target.classList[0];
		const grid = this.grid;
		if (grid != null) {
			switch (buttontype) {
				case 'first':
					grid.selectFirstRow();
					break;
				case 'last':
					grid.selectLastRow();
					break;
				case 'next':
					grid.selectNextRow();
					break;
				case 'previous':
					grid.selectPreviousRow();
					break;
				default:
					break;
			}
		}
	}

	getAttSettings(attName, buildIfMissing = false) {
		let attsetting = this.attsSettings[attName];
		if (attsetting == null && buildIfMissing) {
			attsetting = {};
			this.attsSettings[attName] = attsetting;
		}
		return attsetting;
	}

	saveSettings() {
		SettingManager.setProperty('formManager.attributes', this.attsSettings, this.dataclass);
	}

	buildAllAttributes(includesRelated = false) {
		// const attsSettings = this.attsSettings; // SettingManager.getProperty('formManager.attributes', this.dataclass);
		const atts = this.dataclass.getAllAttributes();
		const attributes = [];
		const manager = this;
		Object.values(atts).forEach((att) => {
			const addAtt = { att, label: att.name, width: 300 };
			// const attSettings = attsSettings == null ? null : attsSettings[att.name];
			const attSettings = manager.getAttSettings(att.name);

			let canAdd = true;
			if (att.kind === 'relatedEntity') {
				if (!includesRelated)
					canAdd = false;
			} else if (att.kind === 'relatedEntities') {
				if (!includesRelated)
					canAdd = false;
			} else {
				addAtt.readOnly = att.readOnly;
				if (att.kind === 'storage' || att.kind === 'calculated' || att.kind === 'alias') {
					switch (att.type) {
						case 'string':
						case 'text':
							addAtt.format = 'text';
							addAtt.inputFormat = 'text';
							addAtt.width = 300;
							break;

						case 'uuid':
							addAtt.format = 'text';
							addAtt.inputFormat = 'text';
							addAtt.width = 280;
							break;

						case 'number':
							addAtt.format = 'number';
							addAtt.inputFormat = 'text';
							addAtt.width = 120;
							break;

						case 'integer':
						case 'word':
							addAtt.format = 'integer';
							addAtt.inputFormat = 'text';
							addAtt.width = 60;
							break;

						case 'long':
						case 'long64':
							addAtt.format = 'integer';
							addAtt.inputFormat = 'text';
							addAtt.width = 120;
							break;

						case 'duration':
							addAtt.format = 'duration';
							addAtt.inputFormat = 'text';
							addAtt.width = 90;
							break;


						case 'date':
							addAtt.format = 'date';
							addAtt.inputFormat = 'text';
							addAtt.width = 120;
							break;

						case 'bool':
						case 'boolean':
							addAtt.format = 'checkbox';
							addAtt.inputFormat = 'checkbox';
							break;

						case 'object':
							addAtt.format = 'object';
							addAtt.inputFormat = 'object';
							addAtt.width = 400;
							addAtt.height = 300;
							break;

						case 'image':
							addAtt.format = 'image';
							addAtt.inputFormat = 'image';
							addAtt.width = 300;
							addAtt.height = 300;
							addAtt.squarePict = false;
							break;

						case 'blob':
							addAtt.format = 'blob';
							addAtt.inputFormat = 'blob';
							addAtt.width = 100;
							break;

						default:
							if (att.kind === 'alias') {
								addAtt.format = 'text';
								addAtt.inputFormat = 'text';
								addAtt.width = 300;
							}
							break;
					}
				}
			}


			if (attSettings != null && attSettings.width != null) {
				addAtt.width = attSettings.width;
			}
			if (attSettings != null && attSettings.height != null) {
				addAtt.height = attSettings.height;
			}
			if (attSettings != null && attSettings.squarePict != null) {
				addAtt.squarePict = attSettings.squarePict;
			}

			if (canAdd)
				attributes.push(addAtt);
		});
		return attributes;
	}

	handleShapeButtonClick(event) {
		const $target = $(event.currentTarget);
		const square = $target.hasClass('squareButton');
		const attName = event.currentTarget.getAttribute('data-attribute');
		if (attName != null) {
			$target.siblings('button').removeClass('shapeButtonSelected');
			$target.addClass('shapeButtonSelected');
			const $image = this.$formContent.find(`.formElem[data-attribute="${attName}"] .formElemImage`);
			if (square) {
				$image.removeClass('rounded');
				$image.addClass('square');
			} else {
				$image.removeClass('square');
				$image.addClass('rounded');
			}
			const attSettings = this.getAttSettings(attName, true);
			attSettings.squarePict = square;
			this.saveSettings();
			this.grid.SetPictColumn(attName, square);
		}

	}

	handleResizedElem(event) {
		const $target = $(event.currentTarget);
		const width = $target.width();
		const height = $target.height();
		const attName = event.currentTarget.parentElement.getAttribute('data-attribute');
		if (attName != null) {
			const attSettings = this.getAttSettings(attName, true);
			attSettings.width = width;
			if ($target.hasClass('formElemImageHolder') || $target.hasClass('formElemObjectHolder'))
				attSettings.height = height;
			this.saveSettings();
		}
	}

	buildForm(attributes) {
		this.$formTitle.html(this.dataclass.getName());
		const $formContent = this.$formContent;
		let html = '';

		attributes.forEach((displayAtt) => {
			let labelclass = 'formElemLabel';
			if (displayAtt.inputFormat === 'image' || displayAtt.inputFormat === 'object')
				labelclass = 'formElemImageLabel';

			const squareselected = displayAtt.squarePict ? 'shapeButtonSelected' : '';
			const roundselected = displayAtt.squarePict ? '' : 'shapeButtonSelected';

			html += `<div class="formElem" data-attribute="${displayAtt.att.name}">`;
			if (displayAtt.inputFormat === 'image') {
				html += `<div class="${labelclass}"><div class="formElemImageLabelText">${displayAtt.label}</div><button class="squareButton ${squareselected}" data-attribute="${displayAtt.att.name}"></button><button class="roundButton ${roundselected}" data-attribute="${displayAtt.att.name}"></button></div>`;
			} else
				html += `<div class="${labelclass}">${displayAtt.label}</div>`;

			if (displayAtt.inputFormat === 'text') {
				html += `<div class="formElemInputHolder" style="width:${displayAtt.width}px;">`;
				html += '<input class="formElemInput" autocomplete="nope" autocorrect="off"/>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'image') {
				html += `<div class="formElemImageHolder" style="height:${displayAtt.height}px;width:${displayAtt.width}px;">`;
				if (displayAtt.squarePict)
					html += '<img class="formElemImage square"/>';
				else
					html += '<img class="formElemImage rounded"/>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'object') {
				html += `<div class="formElemObjectHolder" style="height:${displayAtt.height}px;width:${displayAtt.width}px;">`;
				html += '<pre class="formElemObject "></pre>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'checkbox') {
				html += '<input type="checkbox" class="formElemCheckBox" autocomplete="nope" autocorrect="off"/>';
			} else if (displayAtt.inputFormat === 'blob') {
				html += `<div class="formElemInputHolder" style="width:${displayAtt.width}px;">`;
				html += '<input class="formElemInput blobCell" autocomplete="nope" autocorrect="off"/>';
				html += '</div>';
			}
			html += '</div>';
		});
		$formContent.html(html);

		$formContent.on('click', '.squareButton', this.handleShapeButtonClick.bind(this));
		$formContent.on('click', '.roundButton', this.handleShapeButtonClick.bind(this));

		attributes.forEach((displayAtt) => {
			const att = displayAtt.att;
			const $elem = $formContent.find(`div[data-attribute="${att.name}"`);
			if (displayAtt.inputFormat === 'text') {
				$elem.find('.formElemInputHolder').resizable({ /* autoHide: true, */ handles: 'e' });
				$elem.find('.formElemInputHolder').on('resizestop', this.handleResizedElem.bind(this));
			} else if (displayAtt.inputFormat === 'image') {
				$elem.find('.formElemImageHolder').resizable({ /* autoHide: true, */ handles: 'e, s, se', aspectRatio: 1 });
				$elem.find('.formElemImageHolder').on('resizestop', this.handleResizedElem.bind(this));
			} else if (displayAtt.inputFormat === 'object') {
				$elem.find('.formElemObjectHolder').resizable({ /* autoHide: true, */ handles: 'e, s, se' });
				$elem.find('.formElemObjectHolder').on('resizestop', this.handleResizedElem.bind(this));
			}
		});
	}

	fillForm(entity) {
		const $formContent = this.$formContent;
		this.attributes.forEach((displayAtt) => {
			const att = displayAtt.att;
			let value = null;
			if (entity != null)
				value = entity[att.name];
			const $elem = $formContent.find(`div[data-attribute="${att.name}"`);
			switch (displayAtt.inputFormat) {
				case 'text':
				case 'blob':
					{
						const $input = $elem.find('.formElemInput');
						$input.prop('disabled', true);
						if (value == null) {
							$input.val('null');
							$input.addClass('nullCell');
						} else {
							$input.removeClass('nullCell');
							switch (displayAtt.format) {
								case 'text':
								default:
									$input.val(value);
									break;

								case 'number':
									value = Utils.formatNumber(value, '###,###,###,###,###.####################');
									$input.val(value);
									break;

								case 'integer':
									value = Utils.formatNumber(value, { format:'###,###,###,###,##0', overrideGroup: true });
									$input.val(value);
									break;

								case 'date':
									value = Utils.formatDate(value, 'L');
									$input.val(value);
									break;

								case 'duration':
									value = Utils.formatDuration(value);
									$input.val(value);
									break;

								case 'blob':
									$input.val('binary content');
									break;
							}
						}
					}
					break;

				case 'checkbox':
					{
						const $input = $elem.find('.formElemCheckBox');
						$input.prop('checked', value === true);
						$input.prop('disabled', true);
					}
					break;

				case 'image':
					{
						const imgobj = value;
						value = null;
						if (imgobj != null && typeof (imgobj) === 'object') {
							const deferred = imgobj.__deferred;
							if (deferred != null) {
								const uri = deferred.uri;
								if (uri != null) {
									value = uri;
								}
							}
						}

						if (value == null) {
							$elem.find('.formElemImage').prop('src', '');
							$elem.find('.formElemImage').css('visibility', 'hidden');
						} else {
							$elem.find('.formElemImage').prop('src', value);
							$elem.find('.formElemImage').css('visibility', '');
						}


					}
					break;

				case 'object':
					{
						const $input = $elem.find('.formElemObject');
						/*
						if (value == null)
							value = {};
							*/
						if (displayAtt.jsonEditor == null) {
							displayAtt.jsonEditor = new JsonEditor($input, value, { editable: false });
						} else {
							displayAtt.jsonEditor.load(value);
						}

					}
					break;

				default:
					break;
			}

		});
	}

	destroy() {
		this.$formContent.html('');
		this.$formBar1.find('.formBar1Button').off();
	}


}

